﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page
{
    //this function handles the load event for the page
    protected void Page_Load(object sender, EventArgs e)
    {

    }


    //event handler for the add button
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        //store -1 into the session object to indicate this is a new record
        Session["AddressNo"] = -1;
        //redirect to the data entry page
        Response.Redirect("AnAddress.aspx");
    }

    //event handler for the edit button
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        //var to store the primary key value of the record to be edited
        Int32 AddressNo;
        //if a record has been selected from the list
        if (lstAddresses.SelectedIndex != -1)
        {
            //get the primary key value of the record to edit
            AddressNo = Convert.ToInt32(lstAddresses.SelectedValue);
            //store the data in the session object
            Session["AddressNo"] = AddressNo;
            //redirect to the edit page
            Response.Redirect("AnAddress.aspx");
        }
        else//if no record has been selected
        {
            //display an error
            lblError.Text = "Please select a record to delete from the list";
        }
    }

    //event handler for the delete button
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        //var to store the primary key value of the record to be deleted
        Int32 AddressNo;
        //if a record has been selected from the list
        if (lstAddresses.SelectedIndex != -1)
        {
            //get the primary key value of the record to delete
            AddressNo = Convert.ToInt32(lstAddresses.SelectedValue);
            //store the data in the session object
            Session["AddressNo"] = AddressNo;
            //redirect to the delete page
            Response.Redirect("Delete.aspx");
        }
        else //if no record has been selected
        {
            //display an error
            lblError.Text = "Please select a record to delete from the list";
        }
    }

    //event handler for the apply button
    protected void btnApply_Click(object sender, EventArgs e)
    {

    }

    //event hanlder for the display all button
    protected void btnDisplayAll_Click(object sender, EventArgs e)
    {

    }
}